	function [G, Z, Zref, P, dopt] = POLE_PLACER_LP_EQ_S(Amax, Wc, Amin, wstep, wfi, NIN)
	
	%	Returns the zeros, poles and scaling constant for a lowpass filter with
	%	equiripple passband.
	%	dopt is the final distance to the specification in dB. 
	%	If the specification is not met then dopt < 0.
	%	The routine uses the tranformed variable Z to achieve higher numerical accuracy.
	%	Amax = passband ripple in dB
	%	Wc = passband cutoff angular frequency
	%	Amin = contains piecewise constant stopband attenuation 
	%	wstep = edge frequencies in the stopband
	%	wfi = initial frequencies of the zeros on the imaginary axis
	%	NIN = number of zeros at infinity
	%	wstep and wi may NOT contain any common values.
	
	% Toolbox for ANALOG FILTERS USING MATLAB, Springer, 2009
	
	%	Author: 		Per Lvenborg 1999-03-22
	%	Modified by: 	LW, 2007-12-14, 2011-01-23
	%	Copyright:		by authors - not released for commercial use
	%	Version 		1.0 
	%	Known bugs: 	May not always converge, try another initial placement
	% 	Report bugs to:	Wanhammar@gmail.com
	
	zatt = lp_w2z(wfi, Wc);
	zstep = lp_w2z(wstep, Wc);	
	if min(wfi) < min(wstep)
		disp('Error: Initial attenuation poles not in stop band.')
		return;
	end
	zstep = sort(zstep);
	while 1
		zatt = sort(zatt);
		zarcmin = lp_find_arcmin_epb(zatt,NIN);
		[dmin, zout] = lp_find_dmin2(zstep, zatt, zarcmin, Amin, Amax, NIN);
		[deltaz, dopt] = lp_find_new_poles(zatt, NIN, Amax, zout, dmin);
		if isempty(deltaz)
			break
		end
		zatt = zatt+deltaz;
		for k = 1:length(zatt)
			if zatt(k) <= zstep(1)
				zatt(k) = zstep(1)+rand(1)*0.01;
			elseif zatt(k) >1
	    		zatt(k) = 1-rand(1)*0.01;    
			end
		end
		if max(abs(deltaz)) < 1e-10
			break
		else
			% disp(mean(deltaz))
		end
	end
	ee = lp_get_ee(zatt, NIN, Amax); % ee =f^2 + q^2
	[P, Q] = bairstow(ee);
	wi = lp_z2w(zatt, Wc);
	[P, G] = lp_get_poles(P, Q, Wc, Amax, wi);
	Z = [j*wi -j*wi]';
	F = 1;
	for k = 1:length(NIN)
		F = conv(F,[1 1]);   
	end	
	for k = 1:length(zatt)
		F = conv(F,[1 2*zatt(k) zatt(k)^2]);   
	end
	F = fliplr(F);
	for k = 2:2:length(F)
		F(k) = 0;   
	end
	F = fliplr(F);
	zfi = roots(F);
	zfi = zfi(find(imag(zfi)>0));
	wfi = lp_z2w(zfi, Wc);
	Zref = [0 j*wfi' -j*wfi']';
	P = P';
	G = real(G);
	
